//  Steven Kappes
//  MD2Model.h
//  Description: Class to load/draw models

// Algorithm for loading and animating derived from the book "OpenGL Game Programming"

#ifndef _TRIANGLE_
#define _TRIANGLE_

#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#define M_PI       3.14159265358979323846

typedef struct float4 {
    float x, y, z, w;
} float4;

class Triangle
{	public:
		//ModelPoint v1, v2, v3;	//vertices
		float a, b, c;			//side lengths
		float A, B, C;

		float incenter[3];
		float barycenter[3];
		float pos[3];
		float radius;
		float area;
		float normal[3];
		float bentnormal[3];
		float occlusion;
		
		Triangle(){};
		Triangle(float * v1, float * v2, float * v3);
	private:
		void calcSideLengths(float * v1, float * v2, float * v3);
		void calcAngles();
		void calcIncenter();
		void calcBarycenter(float * v1, float * v2, float * v3);
		void calcRadius(float * v1, float * v2, float * v3);
		void calcNormal(float * v1, float * v2, float * v3);
};

float distance(const float * p0, const float * p1);
float radToDeg(float rad);
float max(float a, float b);
float saturate(float a);
float dot(const float * v1, const float * v2);
void normalize(float * v);
void setval(float * dest, const float * src);
#endif